# Paste Cells from Clipboard
# Copyright 2006 by Alexander V. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 061116 - first version

def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)


# these helper functions edit the grid without calling SetUndo
# (we want to be able to undo the entire pasting at once)

def CreateRow():
    """ Add a row to the end of the report. """
    r = Data.Report[self.ReportID]
    rt = Data.ReportType[r['ReportTypeID']]
    ta = rt.get('TableA')
    if not ta or ta in ('Report', 'ReportColumn', 'ReportRow', 'ReportType', 'ColumnType'): return  # need special handling

    change = {'Table': ta, 'Name': '--'}
    if ta != 'Project':
        change['ProjectID'] = r.get('ProjectID')
    undo = Data.Update(change)
    newid = undo['ID']

    change = {'Table': 'ReportRow', 'ReportID': self.ReportID, 'TableName': ta, 'TableID': newid}
    undo = Data.Update(change)  # created here to control where inserted
    newrowid = undo['ID']

    rlist = Data.GetRowList(self.ReportID)
    rlist.append(newrowid)
    Data.ReorderReportRows(self.ReportID, rlist)
    Data.Recalculate()

def SetCellValue(row, col, value):
    table = self.Report.table
    rowid = table.rows[row]
    of = table.coloffset[col]
    colid = table.columns[col]
    column = Data.SetCellValue(rowid, colid, of, value)


# the main function

def PasteCells():
    if not isinstance(self.Report, wx.grid.Grid):
        hint("Run this script from a grid report.")
        return
    if not self.Report.GetNumberCols():
        hint("Insert columns first.")
        return

    # open clipboard
    data = wx.PyTextDataObject()
    if not wx.TheClipboard.Open():
        hint("Couldn't open clipboard.")
        return
    wx.TheClipboard.GetData(data)
    wx.TheClipboard.Close()
    cells = data.GetText()

    # decide where to paste
    if self.Report.GetNumberRows():
        sel = self.Report.GetSelectedRows()
        if sel:
            row = min(sel)
        else:
            row = self.Report.GetGridCursorRow()
    
        sel = self.Report.GetSelectedCols()
        if sel:
            column = min(sel)
        else:
            column = self.Report.GetGridCursorCol()
    else:
        row = column = 0

    # paste the cells
    for record in cells.splitlines():
        if row >= self.Report.GetNumberRows():  # need more rows
             CreateRow()
             if row >= self.Report.GetNumberRows():  # couldn't add a row
                 break
        c = column
        for value in record.split('\t'):
             if c >= self.Report.GetNumberCols():
                 break
             # self.Report.SetCellValue(row, c, value)
             SetCellValue(row, c, value)
             c += 1
        row += 1

    Data.SetUndo("Paste Cells from Clipboard")

PasteCells()
